function [f_vec3,g_vec3,time_vec3,e_vec3,matrix3] = SBFW (fun_f, grad_f_y,grad_f_x, grad_g_y,...
    grad_g_yx,grad_g_yy,param,X_0, Y_0, X_hat_r)
disp('SBFW Algorithm starts');
%------------------------parameter definition------------------------------
O_indx1_r = param.ind;
a = param.a;
L_g = param.lg;
mu_g = param.mug;
maxiter = param.maxiter;

%initialization
x1= vec(X_0);
x2 = x1;
y= vec(Y_0);
[n,m] = size(X_0);
a0 = min(2/(3*mu_g), mu_g/ (2* L_g^2)); 

tic;
% --------------------------SBFW algorithm--------------------------------
iter = 1;
f_vec3 = [];
g_vec3 = [];
time_vec3 = [];
e_vec3= [];
p = ceil((L_g/mu_g));
d = grad_f_x(x1,y) - (grad_g_yx*(p/L_g)*grad_f_y(x1,y)); 
h2 = d;
eta =  0.8 * 2/ ((maxiter+1)^(3/4));
while iter <= maxiter
    iter = iter+1;
    rho = 2 / (iter^(1/2));
   
    gamma = a0 / (iter^(1/2));
    h_g = grad_g_y(x1,y);

    h1 = h2;
    y = y - gamma*h_g; %y update

    H = grad_f_y(x2,y); 
    p = ceil(2/3*(L_g/mu_g)*log(iter+1));
    i = 0;
    while i<randi(p)
        H = ((speye(n*m,n*m) - (1/L_g)* grad_g_yy(y))) * H;
        i = i+1;
    end
    
    h2 = grad_f_x(x2,y) - (grad_g_yx*(p/L_g)*H); 
    
    d = ((1-rho) * (d - h1 ))+ h2;

    %--------------------------- Find s------------------------------------  
    d1 = reshape(d,[n m]);
   [v,ro] = eigs(d1,1,'smallestreal');
   if ro<0
       s = a*(v*v');
   else
       s = 0*(v*v');
   end
   s = s(:); 
  
    %----------------------------------------------------------------------
    x = (1-eta)*x2 + eta*s; % x update
    
    %normalazied error
    e3 = (sum(((x.* O_indx1_r - X_hat_r.* O_indx1_r).^2)))/ (sum((X_hat_r.* O_indx1_r).^2));

    cpu_t3 = toc;
    f_vec3 = [f_vec3;fun_f(x,y)];
    g_vec3 = [g_vec3;norm(grad_g_y(x,y))];
    e_vec3 = [e_vec3; e3];
    time_vec3 = [time_vec3;cpu_t3];

    x1 = x2;
    x2 = x;
    if cpu_t3>param.maxtime
        break;
    end
end
matrix3 =x;
end
    